﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using DataAccess;
using MDWSLib.MDWSEmrSvc;
using Ext.Net;

//setup an alias for all direct method calls on this control
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "APPLOGIN")]

/// <summary>
/// User control used to login to the application
/// </summary>
public partial class ucAppLogin : System.Web.UI.UserControl
{
    //base master
    public BaseMaster Master { get; set; }

    /// <summary>
    /// US:5348 page load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        divLoginStatus.InnerHtml = "";

        if (!IsPostBack)
        {
          
        }
    }

    /// <summary>
    /// US:5348 load the region, site data etc...
    /// </summary>
    /// <param name="Master"></param>
    public void LoadControl()
    {
        //load the region dropdown only if its not already loaded
        if (ddlRegion.Items.Count < 1)
        {
            //get the region dataset
            CRegionSite region = new CRegionSite(Master);
            DataSet dsRegion = region.GetRegionsDS();

            //load the region dropdown list
            CDropDownList cdl = new CDropDownList();
            cdl.RenderDataSet(Master, dsRegion, ddlRegion, "REGION_NAME", "REGION_ID", "");
        }

        //if params were passed over from cprs then preset the combos and hide them
        lblRegion.Visible = true;
        ddlRegion.Visible = true;
        lblSite.Visible = true;
        ddlSite.Visible = true;
        divRegionSite.Visible = true;
        if (!String.IsNullOrEmpty(Master.SRV))
        {
            if (!String.IsNullOrEmpty(Master.PORT))
            {
                //get the site we want to login to
                CRegionSite crs = new CRegionSite(Master);
                DataSet dsSite = crs.GetSiteDS(Master.SRV, Master.PORT);

                //if not found log off...
                if (CDataUtils2.IsEmpty(dsSite))
                {
                    Master.SRV = String.Empty;
                    Master.PORT = String.Empty;
                    Master.LogOff();
                    return;
                }

                //preset the region and load all sites for this region
                ddlRegion.SelectedValue = CDataUtils2.GetDSStringValue(dsSite, "REGION_ID");
                OnRegionIndexChanged(null, null);

                //preset the site
                ddlSite.SelectedValue = CDataUtils2.GetDSStringValue(dsSite, "SITE_ID");
                
                lblRegion.Visible = false;
                ddlRegion.Visible = false;
                lblSite.Visible = false;
                ddlSite.Visible = false;
                divRegionSite.Visible = false;

                //load the CPA list
                if (ddlCPA.Items.Count < 1)
                {
                    OnSiteIndexChanged(null, null);
                }
            }
        }
        
    }

    /// <summary>
    /// US:5348 load the site dropdown when the region is changed
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void OnRegionIndexChanged(object sender, EventArgs e)
    {
        //get the selected region id
        long lRegionID = -1;
        if (ddlRegion.SelectedValue != null)
        {
            lRegionID = CDataUtils2.ToLong(ddlRegion.SelectedValue);
        }
        
        //clear current sites
        ddlSite.Items.Clear();

        //get site ds
        CRegionSite region = new CRegionSite(Master);
        DataSet dsSite = region.GetSiteDS(lRegionID);

        //load the site dropdownlist
        CDropDownList cdl = new CDropDownList();
        cdl.RenderDataSet(Master, dsSite, ddlSite, "SITE_NAME", "SITE_ID", "");

        ddlRegion.Focus();
         
    }

    /// <summary>
    /// site changed so load the clinical program areas for that site
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void OnSiteIndexChanged(object sender, EventArgs e)
    {
          //get the selected region id
        long lRegionID = -1;
        if (ddlRegion.SelectedValue != null)
        {
            lRegionID = CDataUtils2.ToLong(ddlRegion.SelectedValue);
        }

        //get the selected region id
        long lSiteID = -1;
        if (ddlSite.SelectedValue != null)
        {
            lSiteID = CDataUtils2.ToLong(ddlSite.SelectedValue);
        }

        //clear current sites
        ddlCPA.Items.Clear();

        //get site ds
        CCPA cpa = new CCPA();
        DataSet dsCPA = cpa.GetCPADS(Master, lRegionID, lSiteID);
        DataSet dsView = new DataSet();

        dsView = dsCPA.Clone();

        for (int i = 0; i < dsCPA.Tables[0].Rows.Count; i++)
        {
            if (dsCPA.Tables[0].Rows[i].ItemArray[1].ToString() != "Open Pathway")
            {
                dsView.Tables[0].ImportRow(dsCPA.Tables[0].Rows[i]);
            }
        }
        //load the site dropdownlist
        CDropDownList cdl = new CDropDownList();
        cdl.RenderDataSet(Master, dsView, ddlCPA, "CPA_TITLE", "CPA_ID", "");

        ddlSite.Focus();

    }

    public void EnableControls(bool bEnable)
    {
        ddlCPA.Enabled = bEnable;
        ddlRegion.Enabled = bEnable;
        ddlSite.Enabled = bEnable;
        txtP.Enabled = bEnable;
        txtU.Enabled = bEnable;
        btnLogin.Enabled = bEnable;
        themeDefault.Enabled = bEnable;
        theme508.Enabled = bEnable;
        if (bEnable)
        {
            ddlRegion.Focus();
        }
    }

    public void ShowAlert(string strMsg)
    {
        string strSetAlert = "App.lblErrorMsg.setValue('";
        strSetAlert += strMsg;
        strSetAlert += "');";
                
        strSetAlert += "App.winError.show();";

        System.Web.UI.ScriptManager.RegisterClientScriptBlock(this, 
                                                              this.GetType(), 
                                                              "AlertBoxLogin", 
                                                              strSetAlert, 
                                                              true);
    }

    /// <summary>
    /// US:5348 user clicked the login button, gather credentials and login
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnLogin_Click(object sender, EventArgs e)
    {
        Master.Theme508 = false;
        Master.ThemeDefault = false;
        Master.ThemeNone = false;

        if (theme508.Checked)
        {
            Master.Theme508 = true;
        }

        if (themeDefault.Checked)
        {
            Master.ThemeDefault = true;
        }

        Session["PING_MDWS"] = "1";

        //logging in so clear the initiated session
        Session["SESSION_INITIATED"] = null;

        //dont need to keep this at session state, it keeps itself open
        //we jsut make a new instance for each call
        //Session["EmrSvcSoapClient"] = null;
        
        Master.RegionID = -1;
        Master.SiteID = -1;

        //check to see if we are logging in from MDWs
        if (Master.MDWSTransfer)
        {
            //get the selected region and site id
            long lRegionID = -1;
            if (ddlRegion.SelectedValue != null)
            {
                lRegionID = CDataUtils2.ToLong(ddlRegion.SelectedValue);
            }
            long lSiteID = -1;
            if (ddlSite.SelectedValue != null)
            {
                lSiteID = CDataUtils2.ToLong(ddlSite.SelectedValue);
            }
            long lCPAID = -1;
            string strCPAText = "";
            if (ddlCPA.SelectedValue != null)
            {
                lCPAID = CDataUtils2.ToLong(ddlCPA.SelectedValue);
                if (lCPAID > 0)
                {
                    strCPAText = ddlCPA.SelectedItem.Text;
                }
            }


            //check that the user selected a region, site and entered a username and pwd
            if (lRegionID < 1 ||
                lSiteID < 1 ||
                txtU.Text.Length < 1 ||
                txtP.Text.Length < 1 ||
                lCPAID < 1)
            {

                //show error message
                string strErr = "<div style=\"padding: 10px; \">";
                strErr += "<span role=\"alert\" aria-live=\"assertive\" class=\"login-error\"><img src=\"Images/cancel.png\" alt=\"Transaction Failed\" />&nbsp;";
                
                string strMsg = "Please select a region, site/program area and enter a valid user name and password!";
                strErr += strMsg;

                strErr += "</span>";
                strErr += "</div>";

                //show an alert for 508
                ShowAlert(strMsg);
                
                Session["PING_MDWS"] = null;
        
                divLoginStatus.InnerHtml = strErr;

                return;
            }

            //login to mdws
            EmrSvcSoapClient mdwsSOAPClient = null;
            long lFXUserID = -1;
            string strDUZ = "";
            CMDWSOps ops = new CMDWSOps(Master.GetDataObject());
            CStatus status = ops.MDWSLogin(txtU.Text,
                                           txtP.Text,
                                           lRegionID,
                                           lSiteID,
                                           Master.MDWSEmrSvcContext,
                                           out strDUZ,
                                           out lFXUserID,
                                           out mdwsSOAPClient );


           
            //successful login
            if (status.Status && lFXUserID > 0)
            {
                //check that duz matches CPRS duz
                if (!String.IsNullOrEmpty(Master.DUZ))
                {
                    if (strDUZ != Master.DUZ)
                    {
                        Session["PING_MDWS"] = null;
        
                        Master.LogOff();
                        return;
                    }
                }

                //note: Timeout is set in web.config 
                //todo: look at mdws timeout issues
                //Master.Session.Timeout 

                //create a database session
                CSec sec = new CSec();
                if(!sec.CreateSession(Master, lFXUserID))
                {
                    //show error message
                    string strErr = "<div style=\"padding: 10px; \">";
                    strErr += "<span role=\"alert\" aria-live=\"assertive\" class=\"login-error\"><img src=\"Images/cancel.png\" alt=\"Transaction Failed\" />&nbsp;";
                    
                    string strMsg = "Could not create a new session! Please contact your system administrator!";
                    strErr += strMsg;
                    strErr += "</span>";
                    strErr += "</div>";

                    //show an alert for 508
                    ShowAlert(strMsg);

                    Session["PING_MDWS"] = null;
        
                    divLoginStatus.InnerHtml = strErr;
                    return;
                }

                //we need to audit the successful login
                Master.FXUserID = lFXUserID;
                CSec secS = new CSec();
                secS.SysLogAuditTransaction(Master, 0, "LOGIN|" + Master.GetDataObject().ClientIP + "|" + Master.FXUserID + "|SUCCESS");
                
                //only set here once after successful login
                //dont need to keep this at session state, it keeps itself open
                //we jsut make a new instance for each call
                //Session["EmrSvcSoapClient"] = mdwsSOAPClient;

                //set a session variable with the login time
                Session["SESSION_INITIATED"] = DateTime.Now;

                //keep the region and site id 
                Master.RegionID = lRegionID;
                Master.SiteID = lSiteID;

                //keep the selected CPA ID
                Master.SelectedCPAID = Convert.ToString(lCPAID);
                Master.SelectedCPAText = strCPAText;
                
                //keep the fx_user_id in the db for this session
                Master.SetSessionValue("FX_USER_ID", Convert.ToString(lFXUserID));

                //set the duz, we are now logged in
                Master.DUZ = strDUZ;

                //lookup patient after login
                if (Master.DFN != "")
                {
                    Session["PING_MDWS"] = null;
        
                    //lookup the patient by DFN from MDWS and transfer to the central db
                    //will redirect home if the lookup fails, user can then try to look the 
                    //patient up manually. 
                    Master.LookupPatientByDUZ(Master.DUZ, Master.DFN);
                    return;
                }
                else
                {
                    Session["PING_MDWS"] = null;
        
                    //redirect home
                    Master.GotoHomePage();
                }
            }
            else
            {
                //show error message from MDWS
                string strErr = "<div style=\"padding: 10px; \">";
                strErr += "<span role=\"alert\" aria-live=\"assertive\" class=\"login-error\"><img src=\"Images/cancel.png\" alt=\"Transaction Failed\" />&nbsp;";
                strErr += CDataUtils2.Sanitize(status.StatusComment);
                strErr += "</span>";
                strErr += "</div>";

                //show an alert for 508
                ShowAlert(status.StatusComment);

                divLoginStatus.InnerHtml = strErr;

                Session["SESSION_INITIATED"] = null;

                //we need to audit the failed login
                CSec sec = new CSec();
                sec.SysLogAuditTransaction(Master, 1, "LOGIN|" + Master.GetDataObject().ClientIP + "|FAILED");

                Session["PING_MDWS"] = null;
            }
        }
        else
        {
            Session["PING_MDWS"] = null;
        
            //other supported systems would go here...
        }
        
        Session["PING_MDWS"] = null;
        
    }
}